/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew;

import Krasnodar.rockstarnew.framework.shader.GlProgram;
import Krasnodar.rockstarnew.systems.commands.CommandRegistry;
import Krasnodar.rockstarnew.systems.config.ConfigDropHandler;
import Krasnodar.rockstarnew.systems.config.ConfigManager;
import Krasnodar.rockstarnew.systems.discord.DiscordManager;
import Krasnodar.rockstarnew.systems.event.EventIntegration;
import Krasnodar.rockstarnew.systems.event.EventManager;
import Krasnodar.rockstarnew.systems.event.handlers.ServerConnectionHandler;
import Krasnodar.rockstarnew.systems.file.FileManager;
import Krasnodar.rockstarnew.systems.friends.FriendManager;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.systems.modules.ModuleManager;
import Krasnodar.rockstarnew.systems.modules.constructions.swinganim.SwingManager;
import Krasnodar.rockstarnew.systems.modules.constructions.swinganim.presets.SwingPresetManager;
import Krasnodar.rockstarnew.systems.modules.listeners.ModuleTickListener;
import Krasnodar.rockstarnew.systems.modules.listeners.ModuleWidgetRenderer;
import Krasnodar.rockstarnew.systems.notifications.NotificationManager;
import Krasnodar.rockstarnew.systems.poshalko.PoshalkoHandler;
import Krasnodar.rockstarnew.systems.target.TargetManager;
import Krasnodar.rockstarnew.systems.theme.ThemeManager;
import Krasnodar.rockstarnew.systems.waypoints.WayPointsManager;
import Krasnodar.rockstarnew.ui.account.AccountManager;
import Krasnodar.rockstarnew.ui.hud.Hud;
import Krasnodar.rockstarnew.ui.menu.MenuScreen;
import Krasnodar.rockstarnew.utility.game.TitleBarHelper;
import Krasnodar.rockstarnew.utility.game.WebUtility;
import Krasnodar.rockstarnew.utility.game.server.TPSHandler;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import Krasnodar.rockstarnew.utility.math.calculator.ChatListener;
import Krasnodar.rockstarnew.utility.render.DrawUtility;
import Krasnodar.rockstarnew.utility.rotations.RotationHandler;
import Krasnodar.rockstarnew.utility.rotations.RotationUpdateListener;
import Krasnodar.rockstarnew.utility.sounds.MusicTracker;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import lombok.Generated;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.kotopushka.compiler.sdk.annotations.Compile;
import ru.kotopushka.compiler.sdk.annotations.CompileBytecode;
import ru.kotopushka.compiler.sdk.annotations.Initialization;

public enum Rockstar implements IMinecraft
{
    INSTANCE;

    public static final String NAME = "Rockstar";
    public static final String BUILD_TYPE = "Beta";
    public static final String VERSION = "2.0";
    public static final String MOD_ID = "rockstarnew";
    public static final Logger LOGGER;
    private EventManager eventManager;
    private ThemeManager themeManager;
    private ModuleManager moduleManager;
    private CommandRegistry commandManager;
    private FriendManager friendManager;
    private DiscordManager discordManager;
    private RotationHandler rotationHandler;
    private TargetManager targetManager;
    private MusicTracker musicTracker;
    private FileManager fileManager;
    private NotificationManager notificationManager;
    private ConfigManager configManager;
    private SwingManager swingManager;
    private TPSHandler tpsHandler;
    private Hud hud;
    private ServerConnectionHandler serverConnectionHandler;
    private PoshalkoHandler poshalkoHandler;
    private WayPointsManager wayPointsManager;
    private SwingPresetManager swingPresetManager;
    private MenuScreen menuScreen;
    private ChatListener chatListener;
    private AccountManager accountManager;
    private boolean panic;

    @Compile
    @Initialization
    public void initialize() {
        LOGGER.info("Initializing {}...", (Object)NAME);
        this.musicTracker = new MusicTracker();
        this.wayPointsManager = new WayPointsManager();
        this.eventManager = new EventManager();
        this.friendManager = new FriendManager();
        this.themeManager = new ThemeManager();
        this.discordManager = new DiscordManager();
        this.rotationHandler = new RotationHandler(new RotationUpdateListener());
        this.targetManager = new TargetManager();
        this.fileManager = new FileManager();
        this.moduleManager = new ModuleManager(new ModuleTickListener(), new ModuleWidgetRenderer());
        this.hud = new Hud();
        this.tpsHandler = new TPSHandler();
        this.notificationManager = new NotificationManager();
        this.fileManager.registerClientFiles();
        this.moduleManager.registerModules();
        this.moduleManager.enableModules();
        this.configManager = new ConfigManager();
        this.configManager.handle();
        this.commandManager = new CommandRegistry();
        this.commandManager.initCommands();
        this.swingManager = new SwingManager();
        this.swingPresetManager = new SwingPresetManager();
        this.swingPresetManager.handle();
        this.fileManager.loadClientFiles();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){

            public class_2960 getFabricId() {
                return Rockstar.id("after_shader_load");
            }

            public void method_14491(class_3300 manager) {
                GlProgram.loadAndSetupPrograms();
            }
        });
        DrawUtility.initializeShaders();
        Localizator.loadTranslations();
        this.chatListener = new ChatListener();
        this.serverConnectionHandler = new ServerConnectionHandler();
        this.poshalkoHandler = new PoshalkoHandler();
        this.accountManager = new AccountManager();
        String osName = System.getProperty("os.name");
        String pcName = System.getProperty("user.name");
        if (osName.toLowerCase().contains("windows") && !pcName.equals("sheluvparis")) {
            this.discordManager.connect();
        }
        ConfigDropHandler.init();
        TitleBarHelper.setDarkTitleBar();
        new EventIntegration();
        this.createAvatar();
        LOGGER.info("{} initialized", (Object)NAME);
    }

    public void shutdown() {
        LOGGER.info("Shutting down...");
        this.fileManager.saveClientFiles();
        if (!this.isPanic()) {
            this.configManager.getAutoSaveConfig().save();
        }
        if (!this.isPanic()) {
            this.swingPresetManager.getAutoSavePreset().save();
        }
        this.setPanic(false);
    }

    public static Rockstar getInstance() {
        return INSTANCE;
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    @CompileBytecode
    private void createAvatar() {
        try {
            BufferedImage bufferedImage = ImageIO.read(new URL("https://rockstar.pub/api/avatars/ConeTin.jpg?t=1754613855632"));
            if (bufferedImage == null) {
                return;
            }
            class_2960 id = Rockstar.id("temp/avatar");
            mc.method_1531().method_4616(id, (class_1044)new class_1043(WebUtility.bufferedImageToNativeImage(bufferedImage, true)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Generated
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Generated
    public ThemeManager getThemeManager() {
        return this.themeManager;
    }

    @Generated
    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Generated
    public CommandRegistry getCommandManager() {
        return this.commandManager;
    }

    @Generated
    public FriendManager getFriendManager() {
        return this.friendManager;
    }

    @Generated
    public DiscordManager getDiscordManager() {
        return this.discordManager;
    }

    @Generated
    public RotationHandler getRotationHandler() {
        return this.rotationHandler;
    }

    @Generated
    public TargetManager getTargetManager() {
        return this.targetManager;
    }

    @Generated
    public MusicTracker getMusicTracker() {
        return this.musicTracker;
    }

    @Generated
    public FileManager getFileManager() {
        return this.fileManager;
    }

    @Generated
    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public SwingManager getSwingManager() {
        return this.swingManager;
    }

    @Generated
    public TPSHandler getTpsHandler() {
        return this.tpsHandler;
    }

    @Generated
    public Hud getHud() {
        return this.hud;
    }

    @Generated
    public ServerConnectionHandler getServerConnectionHandler() {
        return this.serverConnectionHandler;
    }

    @Generated
    public PoshalkoHandler getPoshalkoHandler() {
        return this.poshalkoHandler;
    }

    @Generated
    public WayPointsManager getWayPointsManager() {
        return this.wayPointsManager;
    }

    @Generated
    public SwingPresetManager getSwingPresetManager() {
        return this.swingPresetManager;
    }

    @Generated
    public MenuScreen getMenuScreen() {
        return this.menuScreen;
    }

    @Generated
    public ChatListener getChatListener() {
        return this.chatListener;
    }

    @Generated
    public AccountManager getAccountManager() {
        return this.accountManager;
    }

    @Generated
    public boolean isPanic() {
        return this.panic;
    }

    @Generated
    public void setMenuScreen(MenuScreen menuScreen) {
        this.menuScreen = menuScreen;
    }

    @Generated
    public void setPanic(boolean panic) {
        this.panic = panic;
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    }
}

